/*
 * Decompiled with CFR 0.152.
 */
package net.impactdev.impactor.relocations.redis.clients.jedis;

import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import net.impactdev.impactor.relocations.redis.clients.jedis.BuilderFactory;
import net.impactdev.impactor.relocations.redis.clients.jedis.CommandObject;
import net.impactdev.impactor.relocations.redis.clients.jedis.CommandObjects;
import net.impactdev.impactor.relocations.redis.clients.jedis.Connection;
import net.impactdev.impactor.relocations.redis.clients.jedis.Jedis;
import net.impactdev.impactor.relocations.redis.clients.jedis.PipelineBase;
import net.impactdev.impactor.relocations.redis.clients.jedis.Protocol;
import net.impactdev.impactor.relocations.redis.clients.jedis.RedisProtocol;
import net.impactdev.impactor.relocations.redis.clients.jedis.Response;
import net.impactdev.impactor.relocations.redis.clients.jedis.commands.DatabasePipelineCommands;
import net.impactdev.impactor.relocations.redis.clients.jedis.exceptions.JedisDataException;
import net.impactdev.impactor.relocations.redis.clients.jedis.graph.GraphCommandObjects;
import net.impactdev.impactor.relocations.redis.clients.jedis.params.MigrateParams;
import net.impactdev.impactor.relocations.redis.clients.jedis.util.KeyValue;

public class Pipeline
extends PipelineBase
implements DatabasePipelineCommands,
Closeable {
    private final Queue<Response<?>> pipelinedResponses = new LinkedList();
    protected final Connection connection;
    private final boolean closeConnection;

    public Pipeline(Jedis jedis) {
        this(jedis.getConnection(), false);
    }

    public Pipeline(Connection connection) {
        this(connection, false);
    }

    public Pipeline(Connection connection, boolean closeConnection) {
        super(new CommandObjects());
        this.connection = connection;
        this.closeConnection = closeConnection;
        RedisProtocol proto = this.connection.getRedisProtocol();
        if (proto != null) {
            this.commandObjects.setProtocol(proto);
        }
        this.setGraphCommands(new GraphCommandObjects(this.connection));
    }

    @Override
    public final <T> Response<T> appendCommand(CommandObject<T> commandObject) {
        this.connection.sendCommand(commandObject.getArguments());
        Response<T> response = new Response<T>(commandObject.getBuilder());
        this.pipelinedResponses.add(response);
        return response;
    }

    @Override
    public void close() {
        this.sync();
        if (this.closeConnection) {
            this.connection.close();
        }
    }

    @Override
    public void sync() {
        if (!this.hasPipelinedResponse()) {
            return;
        }
        List<Object> unformatted = this.connection.getMany(this.pipelinedResponses.size());
        for (Object rawReply : unformatted) {
            this.pipelinedResponses.poll().set(rawReply);
        }
    }

    public List<Object> syncAndReturnAll() {
        if (this.hasPipelinedResponse()) {
            List<Object> unformatted = this.connection.getMany(this.pipelinedResponses.size());
            ArrayList<Object> formatted = new ArrayList<Object>();
            for (Object rawReply : unformatted) {
                try {
                    Response<?> response = this.pipelinedResponses.poll();
                    response.set(rawReply);
                    formatted.add(response.get());
                }
                catch (JedisDataException e) {
                    formatted.add(e);
                }
            }
            return formatted;
        }
        return Collections.emptyList();
    }

    public final boolean hasPipelinedResponse() {
        return this.pipelinedResponses.size() > 0;
    }

    public Response<Long> waitReplicas(int replicas, long timeout2) {
        return this.appendCommand(this.commandObjects.waitReplicas(replicas, timeout2));
    }

    public Response<KeyValue<Long, Long>> waitAOF(long numLocal, long numReplicas, long timeout2) {
        return this.appendCommand(this.commandObjects.waitAOF(numLocal, numReplicas, timeout2));
    }

    public Response<List<String>> time() {
        return this.appendCommand(new CommandObject<List<String>>(this.commandObjects.commandArguments(Protocol.Command.TIME), BuilderFactory.STRING_LIST));
    }

    @Override
    public Response<String> select(int index) {
        return this.appendCommand(new CommandObject<String>(this.commandObjects.commandArguments(Protocol.Command.SELECT).add(index), BuilderFactory.STRING));
    }

    @Override
    public Response<Long> dbSize() {
        return this.appendCommand(new CommandObject<Long>(this.commandObjects.commandArguments(Protocol.Command.DBSIZE), BuilderFactory.LONG));
    }

    @Override
    public Response<String> swapDB(int index1, int index2) {
        return this.appendCommand(new CommandObject<String>(this.commandObjects.commandArguments(Protocol.Command.SWAPDB).add(index1).add(index2), BuilderFactory.STRING));
    }

    @Override
    public Response<Long> move(String key, int dbIndex) {
        return this.appendCommand(new CommandObject<Long>(this.commandObjects.commandArguments(Protocol.Command.MOVE).key(key).add(dbIndex), BuilderFactory.LONG));
    }

    @Override
    public Response<Long> move(byte[] key, int dbIndex) {
        return this.appendCommand(new CommandObject<Long>(this.commandObjects.commandArguments(Protocol.Command.MOVE).key(key).add(dbIndex), BuilderFactory.LONG));
    }

    @Override
    public Response<Boolean> copy(String srcKey, String dstKey, int db, boolean replace) {
        return this.appendCommand(this.commandObjects.copy(srcKey, dstKey, db, replace));
    }

    @Override
    public Response<Boolean> copy(byte[] srcKey, byte[] dstKey, int db, boolean replace) {
        return this.appendCommand(this.commandObjects.copy(srcKey, dstKey, db, replace));
    }

    @Override
    public Response<String> migrate(String host, int port, byte[] key, int destinationDB, int timeout2) {
        return this.appendCommand(this.commandObjects.migrate(host, port, key, destinationDB, timeout2));
    }

    @Override
    public Response<String> migrate(String host, int port, String key, int destinationDB, int timeout2) {
        return this.appendCommand(this.commandObjects.migrate(host, port, key, destinationDB, timeout2));
    }

    @Override
    public Response<String> migrate(String host, int port, int destinationDB, int timeout2, MigrateParams params, byte[] ... keys2) {
        return this.appendCommand(this.commandObjects.migrate(host, port, destinationDB, timeout2, params, keys2));
    }

    @Override
    public Response<String> migrate(String host, int port, int destinationDB, int timeout2, MigrateParams params, String ... keys2) {
        return this.appendCommand(this.commandObjects.migrate(host, port, destinationDB, timeout2, params, keys2));
    }
}

